

import { ActivityPopup } from './ActivityPopup.js';


export class ActivityLogTab {

	ezTpl = null;
	
	pageNo = 0;
	
	tpl = `
		<div ez-subtemplate="activityresults" class="activity-log-tab">
			<div ez-if="typeof acts == 'undefined' || acts == null">
				Loading...
			</div>
			<div ez-if="typeof acts != 'undefined' && acts != null">
				<table class="table tbl-activities">
					<thead>
						<tr>
							<th style="width: 40px;">#</th>
							<th><input type="text" name="alt_shortDescription" placeholder="Omschrijving" /></th>
							<th style="width: 125px;"><input type="text" name="alt_username" placeholder="{{_('Username')}}" /></th>
							<th style="width: 160px;">Tijdstip</th>
						</tr>
					</thead>
					<tbody ez-for="acts" ez-item="a">
						<tr [onclick]="widget.viewActivity" class="pointer" data-activity-id="{{a.activityId}}">
							<td>{{ a.activityId }}</td>
							<td>{{a.shortDescription}}</td>
							<td>{{a.username != null ? a.username : ''}}</td>
							<td>{{format_datetime(a.created)}}</td>
						</tr>
					</tbody>
						<tr ez-if="acts.length == 0">
							<td colspan="100%" class="no-results">Geen resultaten gevonden</td>
						</tr>
				</table>
				
				<ez-pager></ez-pager>
			</div>
		</div>
	`;
	
	refObject = null;
	refId = null;
	
	constructor( refObject, refId ) {
		this.refObject = refObject;
		this.refId = refId;
	}
	
	
	async loadActivity() {
		
		let data = {};
		data.pageNo = this.pageNo;
		
		data.refObject = this.refObject;
		data.refId = this.refId;
		
		if ( $('.activity-log-tab .tbl-activities thead input').length > 0 ) {
			data.shortDescription = $('input[name=alt_shortDescription]').val();
			data.username = $('input[name=alt_username]').val();
		}
		
		let r = await postUrl(
			'/service/activity.do'
			, data);
			
		let json = await r.json();
		
		if (json.error) {
			showErrorWidget( json );
		}

		let tpl = document.querySelector('[ez-subtemplate="activityresults"]').eztemplate;
		
		let oldThead = document.querySelector( '.tbl-activities thead' );
		let oldActiveElement = document.activeElement;

		tpl.setObject('widget', this);
		tpl.setVar('acts', json.acts);
		tpl.setVar('response', json);
		tpl.render();
		
		if (oldThead) {
			$('.tbl-activities thead').remove();
			$('.tbl-activities').prepend( oldThead );
			
			if (oldActiveElement)
				$(oldActiveElement).focus();
		}
		
		$('.tbl-activities thead tr').find('input').on('change', function() {
			this.pageNo = 0;
			this.loadActivity();
		}.bind(this));
	}
	
	
	render() {
		this.ezTpl = new EzTemplate( this.container );
		this.ezTpl.loadHtml( this.tpl );
		this.ezTpl.render();
		
		this.loadActivity();
	}
	
	selectPage( pageNo ) {
		this.pageNo = pageNo;
		this.loadActivity();
//		gotoRoute( '/masterdata/activity/?pageNo=' + pageNo );
	}
	
	viewActivity( evt ) {
		let activityId = $(evt.currentTarget).data('activity-id');
		
		let ap = new ActivityPopup( activityId );
		ap.showPopup();
	}
	
	show() {
		let navtabContainer = document.querySelector('ul.nav-tabs');
		if (!navtabContainer)
			return;
		
		// create tab
		let li = document.createElement('li');
		li.className = 'nav-item';
		li.role = 'presentation';
		
		let btn = document.createElement('button');
		btn.className = 'nav-link';
		btn.id = 'log-tab';
		btn.setAttribute('data-bs-toggle', 'tab');
		btn.setAttribute('data-bs-target', '#activity-log-tab');
		btn.setAttribute('type', 'button');
		btn.setAttribute('role', 'tab');
		btn.setAttribute('aria-controls', 'actvity-log');
		btn.setAttribute('aria-selected', 'false');
		btn.innerText = 'Log';
		
		li.appendChild( btn );

		navtabContainer.appendChild( li );
		
		// create content pane
		let pane = document.createElement('div');
		pane.setAttribute('class', 'tab-pane fade');
		pane.setAttribute('id', 'activity-log-tab');
		pane.setAttribute('role', 'tabpanel');
		pane.setAttribute('aria-labelledby', 'activity-log-tab');
		
		this.container = document.createElement('div');
		pane.appendChild( this.container );
		
		document.querySelector('div.tab-content').appendChild( pane );
		
		console.log( this.container );
		
		this.render();
	}
	
}

